/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocUpdateException;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.patch.DocPatch;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigUnavailableException;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.StaticSgConfig;
import com.floragunn.searchguard.configuration.validation.ConfigModificationValidators;
import com.floragunn.searchguard.dlic.rest.api.AbstractApiAction;
import com.floragunn.searchguard.dlic.rest.validation.AbstractConfigurationValidator;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProviderRegistry;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchsupport.action.StandardResponse;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContentType;

public abstract class PatchableResourceApiAction
extends AbstractApiAction {
    protected final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());

    public PatchableResourceApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, StaticSgConfig staticSgConfig, ClusterService cs, PrincipalExtractor principalExtractor, AuthorizationService authorizationService, SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry, ThreadPool threadPool, AuditLog auditLog, ConfigModificationValidators configModificationValidators) {
        super(settings, configPath, controller, client, adminDNs, cl, staticSgConfig, cs, principalExtractor, authorizationService, specialPrivilegesEvaluationContextProviderRegistry, threadPool, auditLog, configModificationValidators);
    }

    protected List<RestHandler.Route> getStandardResourceRoutes(String resourceName) {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/api/" + resourceName + "/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/api/" + resourceName + "/"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_searchguard/api/" + resourceName + "/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_searchguard/api/" + resourceName + "/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/_searchguard/api/" + resourceName + "/"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/_searchguard/api/" + resourceName + "/{name}"));
    }

    private void handlePatch(RestChannel channel, RestRequest request, Client client) throws IOException {
        DocPatch jsonPatch;
        SgDynamicConfiguration<?> existingConfiguration;
        if (request.getXContentType() != XContentType.JSON) {
            this.badRequestResponse(channel, "PATCH accepts only application/json");
            return;
        }
        String name = request.param("name");
        try {
            existingConfiguration = this.load(this.getConfigName(), false);
        }
        catch (ConfigUnavailableException e1) {
            this.internalErrorResponse(channel, e1.getMessage());
            return;
        }
        try {
            jsonPatch = DocPatch.parse((String)"application/json-patch+json", (String)request.content().utf8ToString());
        }
        catch (ConfigValidationException e) {
            this.log.debug("Error while parsing JSON patch", (Throwable)e);
            this.badRequestResponse(channel, "Error in JSON patch:\n" + e.toString());
            return;
        }
        try {
            if (Strings.isNullOrEmpty((String)name)) {
                this.handleBulkPatch(channel, request, client, existingConfiguration, jsonPatch);
            } else {
                this.handleSinglePatch(channel, request, client, name, existingConfiguration, jsonPatch);
            }
        }
        catch (ConfigValidationException e) {
            channel.sendResponse(new StandardResponse(e).toRestResponse());
        }
    }

    private void handleSinglePatch(final RestChannel channel, RestRequest request, Client client, final String name, SgDynamicConfiguration<?> existingConfiguration, DocPatch jsonPatch) throws IOException, ConfigValidationException {
        AbstractConfigurationValidator validator;
        DocNode patchedResourceAsDocNode;
        if (this.isHidden(existingConfiguration, name)) {
            this.notFound(channel, this.getResourceName() + " " + name + " not found.");
            return;
        }
        if (this.isReserved(existingConfiguration, name)) {
            this.forbidden(channel, "Resource '" + name + "' is read-only.");
            return;
        }
        if (!existingConfiguration.exists(name)) {
            this.notFound(channel, this.getResourceName() + " " + name + " not found.");
            return;
        }
        Document existingResource = (Document)existingConfiguration.getCEntry(name);
        DocNode existingResourceDocNode = existingResource.toDocNode().splitDottedAttributeNamesToTree();
        try {
            patchedResourceAsDocNode = jsonPatch.apply(existingResourceDocNode);
        }
        catch (DocUpdateException e) {
            this.log.debug("Error while applying JSON patch", (Throwable)e);
            this.badRequestResponse(channel, e.getMessage());
            return;
        }
        patchedResourceAsDocNode = this.postProcessApplyPatchResult(channel, request, existingResourceDocNode, patchedResourceAsDocNode, name);
        if (patchedResourceAsDocNode.getBoolean("hidden") == Boolean.FALSE) {
            patchedResourceAsDocNode = patchedResourceAsDocNode.without(new String[]{"hidden"});
        }
        if (patchedResourceAsDocNode.getBoolean("reserved") == Boolean.FALSE) {
            patchedResourceAsDocNode = patchedResourceAsDocNode.without(new String[]{"reserved"});
        }
        if (patchedResourceAsDocNode.getBoolean("static") == Boolean.FALSE) {
            patchedResourceAsDocNode = patchedResourceAsDocNode.without(new String[]{"static"});
        }
        if (!(validator = this.getValidator(request, patchedResourceAsDocNode)).validate()) {
            request.params().clear();
            this.badRequestResponse(channel, validator);
            return;
        }
        LinkedHashMap<String, Object> updated = new LinkedHashMap<String, Object>((Map<String, Object>)existingConfiguration.toDocNode().toMap());
        updated.put(name, patchedResourceAsDocNode.toBasicObject());
        try (SgDynamicConfiguration mdc = (SgDynamicConfiguration)SgDynamicConfiguration.fromDocNode((DocNode)DocNode.wrap(updated), null, (CType)existingConfiguration.getCType(), (long)existingConfiguration.getDocVersion(), (long)existingConfiguration.getSeqNo(), (long)existingConfiguration.getPrimaryTerm(), (ConfigurationRepository.Context)this.cl.getParserContext()).get();){
            ValidationErrors validationErrors = new ValidationErrors();
            validationErrors.add((Collection)this.configModificationValidators.validateConfig(mdc));
            validationErrors.throwExceptionForPresentErrors();
            this.saveAnUpdateConfigs(client, request, this.getConfigName(), mdc, new AbstractApiAction.OnSucessActionListener<DocWriteResponse>(channel){

                public void onResponse(DocWriteResponse response) {
                    PatchableResourceApiAction.this.successResponse(channel, "'" + name + "' updated.");
                }
            });
        }
    }

    private void handleBulkPatch(final RestChannel channel, RestRequest request, Client client, SgDynamicConfiguration<?> existingConfiguration, DocPatch jsonPatch) throws IOException, ConfigValidationException {
        Object patchedResource;
        Object oldResource;
        DocNode patchedAsDocNode;
        LinkedHashMap<String, Object> patchBase = new LinkedHashMap<String, Object>(existingConfiguration.getCEntries().size());
        for (String resourceName : existingConfiguration.getCEntries().keySet()) {
            Document oldResource2 = (Document)existingConfiguration.getCEntries().get((Object)resourceName);
            patchBase.put(resourceName, oldResource2.toDocNode().splitDottedAttributeNamesToTree().toBasicObject());
        }
        try {
            patchedAsDocNode = jsonPatch.apply(DocNode.wrap(patchBase));
        }
        catch (DocUpdateException e) {
            this.log.debug("Error while applying JSON patch", (Throwable)e);
            this.badRequestResponse(channel, e.getMessage());
            return;
        }
        for (String resourceName : existingConfiguration.getCEntries().keySet()) {
            oldResource = patchBase.get(resourceName);
            patchedResource = patchedAsDocNode.get(resourceName);
            if (oldResource == null || oldResource.equals(patchedResource)) continue;
            if (this.isReserved(existingConfiguration, resourceName)) {
                this.forbidden(channel, "Resource '" + resourceName + "' is read-only.");
                return;
            }
            if (!this.isHidden(existingConfiguration, resourceName)) continue;
            this.badRequestResponse(channel, "Resource name '" + resourceName + "' is reserved");
            return;
        }
        for (String resourceName : patchedAsDocNode.keySet()) {
            AbstractConfigurationValidator validator;
            oldResource = DocNode.wrap(patchBase.get(resourceName));
            patchedResource = DocNode.wrap((Object)patchedAsDocNode.get(resourceName));
            patchedResource = this.postProcessApplyPatchResult(channel, request, (DocNode)oldResource, (DocNode)patchedResource, resourceName);
            if (oldResource != null && oldResource.equals(patchedResource)) continue;
            if (patchedResource.getBoolean("hidden") == Boolean.FALSE) {
                patchedResource = patchedResource.without(new String[]{"hidden"});
            }
            if (patchedResource.getBoolean("reserved") == Boolean.FALSE) {
                patchedResource = patchedResource.without(new String[]{"reserved"});
            }
            if (patchedResource.getBoolean("static") == Boolean.FALSE) {
                patchedResource = patchedResource.without(new String[]{"static"});
            }
            if ((validator = this.getValidator(request, (DocNode)patchedResource)).validate()) continue;
            request.params().clear();
            this.badRequestResponse(channel, validator);
            return;
        }
        try (SgDynamicConfiguration mdc = (SgDynamicConfiguration)SgDynamicConfiguration.fromDocNode((DocNode)patchedAsDocNode, null, (CType)existingConfiguration.getCType(), (long)existingConfiguration.getDocVersion(), (long)existingConfiguration.getSeqNo(), (long)existingConfiguration.getPrimaryTerm(), (ConfigurationRepository.Context)this.cl.getParserContext()).get();){
            ValidationErrors validationErrors = new ValidationErrors();
            validationErrors.add((Collection)this.configModificationValidators.validateConfig(mdc));
            validationErrors.throwExceptionForPresentErrors();
            this.saveAnUpdateConfigs(client, request, this.getConfigName(), mdc, new AbstractApiAction.OnSucessActionListener<DocWriteResponse>(channel){

                public void onResponse(DocWriteResponse response) {
                    PatchableResourceApiAction.this.successResponse(channel, "Resource updated.");
                }
            });
        }
    }

    protected DocNode postProcessApplyPatchResult(RestChannel channel, RestRequest request, DocNode existingResourceAsJsonNode, DocNode updatedResourceAsJsonNode, String resourceName) throws ConfigValidationException {
        return updatedResourceAsJsonNode;
    }

    @Override
    protected void handleApiRequest(RestChannel channel, RestRequest request, Client client) throws IOException {
        if (request.method() == RestRequest.Method.PATCH) {
            this.handlePatch(channel, request, client);
        } else {
            super.handleApiRequest(channel, request, client);
        }
    }

    private AbstractConfigurationValidator getValidator(RestRequest request, DocNode patchedResource) throws JsonProcessingException {
        BytesArray patchedResourceAsByteReference = new BytesArray(patchedResource.toJsonString().getBytes(StandardCharsets.UTF_8));
        return this.getValidator(request, (BytesReference)patchedResourceAsByteReference, new Object[0]);
    }
}

